﻿using System;
using System.Collections.Generic;
using System.Data;
using DataAccess.DataRows;

namespace DataAccess.DataTables
{
    public class MessageDataTable : DataTable
    {
        public MessageDataTable()
        {
            this.Columns.Add(new DataColumn("ID", typeof(int)));
            this.Columns.Add(new DataColumn("GROUP_ID", typeof(int)));
            this.Columns.Add(new DataColumn("TEXT", typeof(string)));
            this.Columns.Add(new DataColumn("SCRIPT", typeof(string)));
        }

        public MessageDataRow this[int index]
        {
            get
            {
                return (MessageDataRow)Rows[index];
            }
        }

        public void Add(MessageDataRow row)
        {
            this.Rows.Add(row);
        }

        public void Remove(MessageDataRow row)
        {
            this.Rows.Remove(row);
        }

        public MessageDataRow GetNewRow()
        {
            MessageDataRow row = (MessageDataRow)NewRow();
            return row;
        }

        protected override Type GetRowType()
        {
            return typeof(MessageDataRow);
        }

        protected override DataRow NewRowFromBuilder(DataRowBuilder builder)
        {
            return new MessageDataRow(builder);
        }

        public IEnumerator<MessageDataRow> GetEnumerator()
        {
            List<MessageDataRow> rows = new List<MessageDataRow>();

            for (int i = 0; i < this.Rows.Count; i++)
            {
                rows.Add((MessageDataRow)this.Rows[i]);
            }
            return rows.GetEnumerator();
        }
    }
}